local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// label.
	self.Label = vgui.Create( "label", self );
	self.Label:SetMouseInputEnabled( false );
	
	// linked to
	self.LinkedClass = nil;
	
end


// set text
function PANEL:SetText( txt )
	self.Label:SetText( txt );
	
	// reposition
	self:InvalidateLayout();
	
end


// perform layout
function PANEL:PerformLayout( )
	// position label.
	self.Label:SizeToContents();
	
	// get height.
	local ofsy = self:GetTall() * 0.5 - self.Label:GetTall() * 0.5;
	
	// set
	self.Label:SetPos( 8, ofsy );
	
end

// scheme
function PANEL:ApplySchemeSettings( )
	// set fonts.
	self.Label:SetFont( AppFramework:Theme().fonts['text'] );
	self.Label:SetFGColor( AppFramework:Theme().colors['text'] );
	
end


// register
vgui.Register( "ctl_label", PANEL, "Panel" );




// create app framework control.
CtlLabel_class 	= Control_class:create( nil, false, "ctl_label" );

// set text
function CtlLabel_class:SetText( txt )
	self:GetHandle():SetText( txt );	

end
